/**
 * \file: mspin_lm_touch_adapter.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin LayerManager Touch and Pointer Event Adapter
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES thilobjoern.fickel@bosch-softtec.com
 *
 * \copyright: (c) 2015 Bosch SoftTec
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_LM_TOUCH_ADAPTER_H_
#define MSPIN_LM_TOUCH_ADAPTER_H_

#include "mspin_lm_adapter_typedef.h"

#include <wayland-client.h>

void mspin_lm_touchHandleDown(void* data, struct wl_touch* touch, uint32_t serial, uint32_t wltime,
                struct wl_surface* surface, int32_t id, wl_fixed_t xw, wl_fixed_t yw);

void mspin_lm_touchHandleUp(void* data, struct wl_touch* touch, uint32_t serial, uint32_t wltime, int32_t id);

void mspin_lm_touchHandleMotion(void* data, struct wl_touch* touch, uint32_t wltime, int32_t id,
                  wl_fixed_t xw, wl_fixed_t yw);

void mspin_lm_touchHandleFrame(void* data, struct wl_touch* touch);

void mspin_lm_touchHandleCancel(void* data, struct wl_touch* touch);

void mspin_lm_pointerHandleEnter(void* data, struct wl_pointer* wlPointer, uint32_t serial,
                   struct wl_surface* wlSurface, wl_fixed_t sx, wl_fixed_t sy);

void mspin_lm_pointerHandleLeave(void* data, struct wl_pointer* wlPointer, uint32_t serial,
                   struct wl_surface* wlSurface);

void mspin_lm_pointerHandleMotion(void* data, struct wl_pointer* wlPointer, uint32_t time,
                    wl_fixed_t sx, wl_fixed_t sy);

void mspin_lm_pointerHandleButton(void* data, struct wl_pointer* wlPointer, uint32_t serial,
                    uint32_t time, uint32_t button, uint32_t state);

void mspin_lm_pointerHandleAxis(void* data, struct wl_pointer* wlPointer, uint32_t time,
                  uint32_t axis, wl_fixed_t value);

void mspin_lm_pointerHandleFrame(void *data, struct wl_pointer *wlPointer);

void mspin_lm_pointerHandleAxisSource(void *data, struct wl_pointer *wlPointer, uint32_t source);

void mspin_lm_pointerHandleAxisStop(void *data, struct wl_pointer *wlPointer,
            uint32_t time, uint32_t axis);

void mspin_lm_pointerHandleAxisDiscrete(void *data, struct wl_pointer *wlPointer,
            uint32_t axis, int32_t discrete);

#endif /* MSPIN_LM_TOUCH_ADAPTER_H_ */
